using System;
using System.Collections.Generic;
using System.Xml.Serialization;

namespace VdcCommon.BusinessEntities
{

    public enum DateEnumForSearch
    {
        Today = 1,
        Yesterday = 2,
    }
   
    public partial class DbUser
    {
        public DbUser() { }

        public DbUser(AdUser adUser)
        {
            user_id = adUser.UserId;
            username = adUser.UserName;
            name = adUser.Name;
            surname = adUser.SurName;
            department = adUser.Department;
            domain = adUser.DomainControler;
            email = adUser.Email;
            groups = adUser.Group;
            status = (int)AdRefStatus.Active;
        }

		[XmlIgnoreAttribute]
		public AdRefStatus AdStatus
		{
			get
			{
				if (status == 0)
				{
					return AdRefStatus.Inactive;
				}
				else
				{
					return AdRefStatus.Active;
				}
			}
			set
			{
				// do nothing for nothing
			}
		}

        [XmlIgnoreAttribute]
        public bool IsGroup
        {
            get
            {
                return string.IsNullOrEmpty(username);
            }
            set
            {
                // do nothing for nothing
            }
        }

        #region IVdcQueryable Members

        [XmlIgnoreAttribute]
        public override object QueryableId
        {
            get { return user_id; }
        }

		private static readonly List<string> _vmProperties =
                       new List<string> { "name", "surname", "username", "groups", "session_count", "TimeLeasedFrom", "TimeLeasedTo", "IsLogedin", "LastAdminCheckStatus" };
        [XmlIgnoreAttribute]
        public override List<string> ChangeablePropertiesList
        {
            get { return _vmProperties; }
        }

        #endregion
	}

    
    public partial class ad_groups
    {
		// Note that the domain property in this file is commented.
		// Instead, there is another 'domain' property within the 'Reference.cs' file,
		// which seems like the property that is exposed via the WSDL.
        //private string mDomain;
		public ad_groups()
		{
		}

    	public ad_groups(Guid id, String name)
        {
            this.id = id;
            this.name = name;
        }
         public ad_groups(Guid id, String name, string domain): this (id,name)
         {
			 this.domain = domain;
         }

        #region IVdcQueryable Members

        [XmlIgnoreAttribute]
        public override object QueryableId
        {
            get { return id; }
        }
        [XmlIgnoreAttribute]
        public override List<string> ChangeablePropertiesList
        {
            get { return null; }
        }

        #endregion
    }
}